<?php

namespace App\Exports\SuperAdmin;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TherapistCategoriesExport implements FromArray, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    protected $therapist_categories;
    public function __construct($therapist_categories)
    {
        $this->therapist_categories = $therapist_categories;
    }
    public function array(): array
    {
        $data = [];
        foreach ($this->therapist_categories as $therapist_category) {
            $single = [$therapist_category->id, $therapist_category->name, $therapist_category->description, $therapist_category->is_active, $therapist_category->slug, date_format($therapist_category->created_at, 'd-m-Y')];
            $data[] = $single;
        }
        return $data;
    }
    public function headings(): array
    {
        return ["id", "name", "description", "is_active", "slug", "created_at"];
    }
}
